// ActionScript file
package  {
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filesystem.*;
	
	import mx.controls.Alert;


	public class ResultIcon extends Sprite{
		
		// Constants:
		private const screenXCenter:int=700;
		private const screenYCenter:int=350;
		private const screenXMax:int=1250;
		private const screenYMax:int=650;
		private const constRadius:Number=1.5;
		private const screenXMin:int = 350;
		private const screenYMin:int = 10;
		//const closestToCenter:Number = 1;//circles cannot be closer than this to center of screen
		// Public Properties:
		// Private Properties:
		public var score:Number;
		public var lastRadius:Number=0 ;
		public var xPos:int;
		public var yPos:int;
		public var maxAge:int;
		public var age:int; 
		private var IconRadius:Number=0;
		public var iconInfo:Array = new Array(); 
		public var relevance:Number;
		public var biddingRate:Number=0;
		private var iconValues:Array= new Array();
		private var circleCount:uint;
		private var circularMode:Boolean;
		private var showingInfo:Boolean = false;
		private var infoMsgBox:MessageBox;
		private var indicatorLine:Shape;
		private var rotationAngle:Number = 0;
		public var highlighted:Boolean = false;
		public var highlightCircle:Circle;
		private var circle:Array = new Array();
		
		public var ID:int;
		public static var IDGen:int=0;
		public static var clickTime:Date;
		public static var beginTime:Date=new Date();
		public static var filePath:File = new File("C:\\out.txt");
		public static var outputFile:FileStream = new FileStream();
		public static var selectedIcon:ResultIcon;
		public static var selectedList:Array = new Array();
		public static var currentIcon:ResultIcon;
		public static var multipleselection:Boolean;
		
		{
			outputFile.open(filePath,"append");
		}
		
		public function copyResultIcon():ResultIcon{
			
			return new ResultIcon(this.relevance,this.age,this.biddingRate,this.iconValues,this.iconInfo,this.circularMode,this.maxAge,this.circleCount);
			
		}
		// Initialization:
		//age is expressed in terms of days (?), all icon values are normalized
		//circleCount = number of circles including the "used" circle in center
		public function ResultIcon(iconRelevance:Number,iconAge:int, bidRate:int, iconValues1:Array, iconInfo1:Array, circularMode1:Boolean, maximumAge:int, circleCount1:uint=5) { 
	//	lastRadius=constRadius; //or ending time
		var i:int = 0;
		var sum:Number = 0;
		highlighted = false;
		ID = IDGen++;
		//storing icon information
		relevance =iconRelevance;
		age =iconAge;
		iconValues =iconValues1;
		iconInfo = iconInfo1; 
		circleCount= circleCount1;
		maxAge = maximumAge; 
		biddingRate = bidRate;
		circularMode = circularMode1;
		
		//make icon an interactive object
		//this.buttonMode = true;
		//creating icon
		calcPosition(relevance,age,circularMode);
		//if we use xy coordinates, we do not want to change icon size with age
		if(circularMode ==false){
			age=30;
		}
		trace(circularMode);
	//initial value for used/new circle
		IconRadius = 10;
		sum=5;
		for ( i=0;i<circleCount;i++)
		{
			IconRadius += iconValues[i]*constRadius;
			sum += iconValues[i];
		}	
		
		lastRadius= IconRadius;			
		var circleRadius:int=0;
		for ( i=0;i<circleCount-1;i++)
		{

			if(iconValues[i] != 0){
				circleRadius = 2*(lastRadius*Math.sqrt((age+10)/(maxAge+10)));//2 is only an adjustment factor
				trace("circleRadius"+i+":\t"+circleRadius);
				circle[i]= new Circle(xPos,yPos,circleRadius,i,false);
				lastRadius = lastRadius-iconValues[i]*constRadius;
				addChild(circle[i]);

			}
		}
		circleRadius = (lastRadius*Math.sqrt((age+10)/(maxAge+10)));
		if(iconValues[i]==0)//New item->choose black color
			circle[circleCount-1]= new Circle(xPos,yPos,circleRadius,i,false);
		else//used item->choose white
			circle[circleCount-1]= new Circle(xPos,yPos,circleRadius,i+1,false);
		addChild(circle[circleCount-1]);
		
	
		
		//this is a hallow circle that will only appear if you click on the icon
		highlightCircle = new Circle(xPos,yPos,2*(IconRadius*Math.sqrt((age+10)/(maxAge+10))),0,true);
		
		
		//drawing indicator line: it shows bidding rate: only 4 values={0,1,2,3} larger values shows higher bidding rate
		var r:Number= 2*(IconRadius*Math.sqrt((age+10)/(maxAge+10)));
		var angle:Number = biddingRate*deg2rad(90);
		indicatorLine = new Shape();
		indicatorLine.graphics.lineStyle(3,0x00000000,100);
		indicatorLine.graphics.moveTo(xPos, yPos); 
		indicatorLine.graphics.lineTo(xPos+r*Math.cos(angle)-1, yPos-r*Math.sin(angle)-1);
		addChild(indicatorLine);
		
			//this is to show icon info while mouse is on Icon
		this.addEventListener(MouseEvent.CLICK,highlightIcon);
		this.addEventListener(MouseEvent.MOUSE_OVER,showIconInfo);
		this.addEventListener(MouseEvent.MOUSE_OUT,hideIconInfo);
		this.addEventListener(MouseEvent.RIGHT_CLICK,showIconInfo);
								
		}
	
		public function showIconInfo(e:MouseEvent):void{

			showingInfo=true;
			currentIcon = this;
			}
		
		public function hideIconInfo(e:MouseEvent):void{
			
			showingInfo=false;
			currentIcon=null;
		}
		public function calcPosition( relevance:Number, age:int, circularMode:Boolean):void{
			
			if(circularMode==true){
				var angle:Number = 3.6*(100-relevance);
				var radians:Number = deg2rad(angle);
				trace(angle);
				//normalize age for radius
				trace("age",age);
				var radius:Number = (age/maxAge)*500; //500 is only an adjustment factor
				xPos= screenXCenter+radius*Math.cos(radians);
				yPos= screenYCenter-radius*Math.sin(radians);
			}
			else{
				xPos = screenXMin+(screenXMax-screenXMin)*((age+10)/(maxAge+10));
				yPos = screenYMin+(screenYMax-screenYMin)*(1-(relevance/100));
				
			}

		}//end of function
		
		function deg2rad(deg:Number):Number {
	    return deg*(Math.PI/180);
		}
		
		function highlightIcon(e:Event){
			
			if(selectedIcon != null && selectedIcon != this && multipleselection == false)
			{
				Alert.show("You must undo the previous selection by clicking on it, in order to be able to select another icon!");
				return;
			}	
			
			if(highlighted == false){
				addChild(highlightCircle);
				highlighted = true;
				selectedIcon = this;
				saveClickTime();
				return;
			}
			else{
				removeChild(highlightCircle);
				highlighted= false;
				saveUnclickTime();
				selectedIcon = null;
			}
			
		}//end of function
		public function move(x:int,y:int){
			
			xPos = x;
			yPos=y;
			
			for(var i:int=0; i<circleCount; i++)
				circle[i].move(x,y);
			
			highlightCircle.move(x,y);
			removeChild(indicatorLine);
		
			
			//drawing indicator line: it shows bidding rate: only 4 values={0,1,2,3} larger values shows higher bidding rate
			var r:Number= 2*(IconRadius*Math.sqrt((age+10)/(maxAge+10)));
			var angle:Number = biddingRate*deg2rad(90);
			indicatorLine = new Shape();
			indicatorLine.graphics.lineStyle(3,0x00000000,100);
			indicatorLine.graphics.moveTo(x, y); 
			indicatorLine.graphics.lineTo(x+r*Math.cos(angle)-1, y-r*Math.sin(angle)-1);
			addChild(indicatorLine);
			
		}
		
		
		public function saveClickTime():void{
			
			clickTime = new Date();
			trace(clickTime.getTime()-beginTime.getTime());
			//C:\Hasti Drive\courses\spring09\Knowledge Vis\assignments\final project\New proposal and project\out.txt");
			trace("file name"+filePath.nativePath);
			outputFile.writeMultiByte("\n-----------------------------------","utf-8");
			outputFile.writeMultiByte("\ntime to click:\t"+(clickTime.getTime()-beginTime.getTime()),"utf-8");
			outputFile.writeMultiByte("\nclicked Icon :\t"+returnString(),"utf-8");
	//		selectedIcon = this;

			//outputFile.writeMultiByte(clickTime.getTime()-beginTime.getTime());
					
		}
		public function saveUnclickTime():void{
			clickTime = new Date();
			trace(clickTime.getTime()-beginTime.getTime());
			//C:\Hasti Drive\courses\spring09\Knowledge Vis\assignments\final project\New proposal and project\out.txt");
			trace("file name"+filePath.nativePath);
			outputFile.writeMultiByte("\n-----------------------------------","utf-8");
			outputFile.writeMultiByte("\ntime to undoing click:\t"+(clickTime.getTime()-beginTime.getTime()),"utf-8");
			outputFile.writeMultiByte("\n undo click on Icon :\t"+returnString(),"utf-8");
	//		selectedIcon = null;

		}
		
		public static function savefinalizeTime():void{
			
			if(selectedIcon == null)
			{
				Alert.show("You should Choose An Icon Before Finalizing!");
				return;	
			}	
			var finalizeTime:Date = new Date();
			
			outputFile.open(filePath,"append");
			outputFile.writeMultiByte("\n{{***********************************","utf-8");
			outputFile.writeMultiByte("\ntime to finalize:\t"+(finalizeTime.getTime()-beginTime.getTime()),"utf-8");
			outputFile.writeMultiByte("\nclicked Icon :\t"+selectedIcon.returnString(),"utf-8");	
			outputFile.writeMultiByte("\n***********************************}}","utf-8");
			Alert.show("You just finalized your selection!");
			selectedIcon.highlighted=false;
			selectedIcon.removeChild(selectedIcon.highlightCircle);
			selectedIcon = null;
			beginTime = new Date();
			//	Application.application.exit();
		}//end of function(savefinalizeTime)
		
		public function returnString(){
			
			var text:String;
			for(var i:int;i<iconInfo.length;i++)
			{
				if(i==1 || i==2)
					;
				else
					text += iconInfo[i] + ",\t";
			}
			
			text += "bidrate:"+biddingRate+",\tRelevance:"+relevance+"\n";
			return text;
		}
		// Public Methods:
		// Protected Methods:
	}//end of class
	
}//end of package
